﻿using Microscopic_Traffic_Simulator.Renderers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Microscopic_Traffic_Simulator.Views.MainWindowView
{
    /// <summary>
    /// Actions related to moving with canvas.
    /// </summary>
    class CanvasMover
    {
        /// <summary>
        /// List of all renderers attached to the canvas.
        /// </summary>
        private List<VisualCanvasRenderer> renderers;

        /// <summary>
        /// Initialize with list of renderers attached to the canvas.
        /// </summary>
        /// <param name="renderers">List of all renderers attached to the canvas.</param>
        internal CanvasMover(List<VisualCanvasRenderer> renderers)
        {
            this.renderers = renderers;
        }

        /// <summary>
        /// Reset canvas move operation after it is finished.
        /// </summary>
        internal void ResetLastMousePositionToRenderersForMovingCanvas()
        {
            renderers.ForEach(i => i.ResetCanvasMove());
        }

        /// <summary>
        /// Set new location of mouse cursor used for moving canvas.
        /// </summary>
        /// <param name="currentMouseLocationOnCanvas">Current location of mouse cursor.</param>
        internal void SetLastMousePositionToRenderersForMovingCanvas(Point currentMouseLocationOnCanvas)
        {
            renderers.ForEach(i => i.PushNewMouseLocationOfCanvasMove(currentMouseLocationOnCanvas));
        }
    }
}
